<?php
include "../db.php";

function dosyacevir($text){
	$find = array("/Ğ/","/Ü/","/Ş/","/İ/","/Ö/","/Ç/","/ğ/","/ü/","/ş/","/ı/","/ö/","/ç/");
	$degis = array("G","U","S","I","O","C","g","u","s","i","o","c");
	$text = preg_replace("/[^0-9a-zA-ZÄzÜŞİÖÇğüşıöç.]/"," ",$text);
	$text = preg_replace($find,$degis,$text);
	$text = preg_replace("/ +/"," ",$text);
	$text = preg_replace("/ /","-",$text);
	$text = preg_replace("/\s/","",$text);
	$text = strtolower($text);
	$text = preg_replace("/^-/","",$text);
	$text = preg_replace("/-$/","",$text);
	return $text;
}

function resize($newWidth, $targetFile, $originalFile) {

    $info = getimagesize($originalFile);
    $mime = $info['mime'];

    switch ($mime) {
            case 'image/jpeg':
                    $image_create_func = 'imagecreatefromjpeg';
                    $image_save_func = 'imagejpeg';
                    $new_image_ext = 'jpg';
                    break;

            case 'image/png':
                    $image_create_func = 'imagecreatefrompng';
                    $image_save_func = 'imagepng';
                    $new_image_ext = 'png';
                    break;

            case 'image/gif':
                    $image_create_func = 'imagecreatefromgif';
                    $image_save_func = 'imagegif';
                    $new_image_ext = 'gif';
                    break;

            default: 
                    throw new Exception('Unknown image type.');
    }

    $img = $image_create_func($originalFile);
    list($width, $height) = getimagesize($originalFile);

    $newHeight = ($height / $width) * $newWidth;
    $tmp = imagecreatetruecolor($newWidth, $newHeight);
    imagecopyresampled($tmp, $img, 0, 0, 0, 0, $newWidth, $newHeight, $width, $height);

    if (file_exists($targetFile)) {
            unlink($targetFile);
    }
    $image_save_func($tmp, $targetFile);
}

function resizekare($source_image, $destination, $tn_w, $tn_h, $quality = 100, $wmsource = false)
{
    $info = getimagesize($source_image);
    $imgtype = image_type_to_mime_type($info[2]);

    #assuming the mime type is correct
    switch ($imgtype) {
        case 'image/jpeg':
            $source = imagecreatefromjpeg($source_image);
            break;
        case 'image/gif':
            $source = imagecreatefromgif($source_image);
            break;
        case 'image/png':
            $source = imagecreatefrompng($source_image);
            break;
        default:
            die('Invalid image type.');
    }

    #Figure out the dimensions of the image and the dimensions of the desired thumbnail
    $src_w = imagesx($source);
    $src_h = imagesy($source);


    #Do some math to figure out which way we'll need to crop the image
    #to get it proportional to the new size, then crop or adjust as needed

    $x_ratio = $tn_w / $src_w;
    $y_ratio = $tn_h / $src_h;

    if (($src_w <= $tn_w) && ($src_h <= $tn_h)) {
        $new_w = $src_w;
        $new_h = $src_h;
    } elseif (($x_ratio * $src_h) < $tn_h) {
        $new_h = ceil($x_ratio * $src_h);
        $new_w = $tn_w;
    } else {
        $new_w = ceil($y_ratio * $src_w);
        $new_h = $tn_h;
    }

    $newpic = imagecreatetruecolor(round($new_w), round($new_h));
    imagecopyresampled($newpic, $source, 0, 0, 0, 0, $new_w, $new_h, $src_w, $src_h);
    $final = imagecreatetruecolor($tn_w, $tn_h);
    $backgroundColor = imagecolorallocate($final, 255, 255, 255);
    imagefill($final, 0, 0, $backgroundColor);
    //imagecopyresampled($final, $newpic, 0, 0, ($x_mid - ($tn_w / 2)), ($y_mid - ($tn_h / 2)), $tn_w, $tn_h, $tn_w, $tn_h);
    imagecopy($final, $newpic, (($tn_w - $new_w)/ 2), (($tn_h - $new_h) / 2), 0, 0, $new_w, $new_h);

    #if we need to add a watermark
    if ($wmsource) {
        #find out what type of image the watermark is
        $info    = getimagesize($wmsource);
        $imgtype = image_type_to_mime_type($info[2]);

        #assuming the mime type is correct
        switch ($imgtype) {
            case 'image/jpeg':
                $watermark = imagecreatefromjpeg($wmsource);
                break;
            case 'image/gif':
                $watermark = imagecreatefromgif($wmsource);
                break;
            case 'image/png':
                $watermark = imagecreatefrompng($wmsource);
                break;
            default:
                die('Invalid watermark type.');
        }

        #if we're adding a watermark, figure out the size of the watermark
        #and then place the watermark image on the bottom right of the image
        $wm_w = imagesx($watermark);
        $wm_h = imagesy($watermark);
        imagecopy($final, $watermark, $tn_w - $wm_w, $tn_h - $wm_h, 0, 0, $tn_w, $tn_h);

    }
    if (imagejpeg($final, $destination, $quality)) {
        return true;
    }
    return false;
}


if(isset($_FILES['files'])){
$files=Array();
foreach($_FILES['files']['tmp_name'] as $key=>$value){
$dosyaadi=dosyacevir($_FILES['files']['name'][$key]);

if(file_exists("resimler/".$dosyaadi)){
$dosyaisim=str_replace(".".pathinfo($dosyaadi, PATHINFO_EXTENSION),"",$dosyaadi);
$dosyaadi=$dosyaisim.time().".".pathinfo($dosyaadi, PATHINFO_EXTENSION);
}
move_uploaded_file($_FILES['files']['tmp_name'][$key], "resimler/".$dosyaadi);


if(strpos($_FILES['files']['type'][$key],"image")!==false){
$file="resimler/".$dosyaadi;
resize(600, $file, $file);
}

$yeni = $db->prepare("INSERT INTO galeri SET dosyano=:dosyano, name=:name, url=:url, size=:size, time=:time, type=:type, extension=:extension, width=:width, height=:height, uyeid=:uyeid ");
$yeni->bindValue(':dosyano', $_GET['dosyano']);
$yeni->bindValue(':name', $dosyaadi);
$yeni->bindValue(':url', dirname($_SERVER['REQUEST_URI'])."/resimler/".$dosyaadi);
$yeni->bindValue(':size', $_FILES['files']['size'][$key]);
$yeni->bindValue(':time', time());
$yeni->bindValue(':type', $_FILES['files']['type'][$key]);
$yeni->bindValue(':extension', pathinfo($dosyaadi, PATHINFO_EXTENSION));
if(strpos($_FILES['files']['type'][$key],"image")!==false){
$image_info = getimagesize("resimler/".$dosyaadi);
$image_width = $image_info[0];
$image_height = $image_info[1];
$yeni->bindValue(':width', $image_width);
$yeni->bindValue(':height', $image_height);
}else{
$yeni->bindValue(':width', 0);
$yeni->bindValue(':height', 0);
}
$yeni->bindValue(':uyeid', isset($uyeid) ? $uyeid:0 );
$yeni->execute();

$files[$key]['name']=$dosyaadi;
$files[$key]['url']=dirname($_SERVER['REQUEST_URI'])."/resimler/".$dosyaadi;
$files[$key]['size']=$_FILES['files']['size'][$key];
$files[$key]['time']=time();
$files[$key]['type']=$_FILES['files']['type'][$key];
$files[$key]['extension']=pathinfo($dosyaadi, PATHINFO_EXTENSION);

if(strpos($_FILES['files']['type'][$key],"image")!==false){
$files[$key]['versions']['thumb']['name']=$dosyaadi;
$files[$key]['versions']['thumb']['url']=dirname($_SERVER['REQUEST_URI'])."/resimler/".$dosyaadi;
$image_info = getimagesize("resimler/".$dosyaadi);
$image_width = $image_info[0];
$image_height = $image_info[1];
$files[$key]['width']=$image_width;
$files[$key]['height']=$image_height;
}
}
print_r(json_encode($files));
}

if(isset($_POST['_method'])){
if($_POST['_method']=='PATCH'){

$file="resimler/".basename($_POST['file']);
if(pathinfo($file, PATHINFO_EXTENSION)=='png'){
$im = imagecreatefrompng($file);
}else{
$im = imagecreatefromjpeg($file);
}
$im = imagerotate($im, 0-$_POST['rotate'], 0);
$size = min(imagesx($im), imagesy($im));
$im2 = imagecrop($im, ['x' => $_POST['x'], 'y' => $_POST['y'], 'width' => $_POST['width'], 'height' => $_POST['height']]);
if ($im2 !== FALSE) {
	if(pathinfo($file, PATHINFO_EXTENSION)=='png'){
    imagepng($im2, $file);
	}else{
	imagejpeg($im2, $file);
	}
    imagedestroy($im2);
}
imagedestroy($im);

$files['name']=basename($_POST['file']);
$files['url']=dirname($_SERVER['REQUEST_URI'])."/".$file;
$files['size']=filesize($file);
$files['time']=time();
$files['type']=filetype($file);
$files['extension']=pathinfo($file, PATHINFO_EXTENSION);
$files['versions']['thumb']['name']=basename($_POST['file']);
$files['versions']['thumb']['url']=dirname($_SERVER['REQUEST_URI'])."/".$file;
print_r(json_encode($files));
}


if($_POST['_method']=='DELETE'){
$file="resimler/".$_POST['files'][0];

$yeni = $db->prepare("DELETE from galeri where name=:name ");
$yeni->bindValue(':name', $_POST['files'][0]);
$yeni->execute();

unlink($file);
echo '{"'.$_POST['files'][0].'":true}';
}
}



if(isset($_GET['limit'])){
$files=Array();
$key=-1;
foreach($db->query("SELECT * FROM galeri where dosyano='".$_GET['dosyano']."' order by id desc") as $row) {
$key=$key+1;
$files['files'][$key]['name']=$row['name'];
$files['files'][$key]['url']=$row['url'];
$files['files'][$key]['size']=$row['size'];
$files['files'][$key]['time']=$row['time'];
$files['files'][$key]['type']=$row['type'];
$files['files'][$key]['extension']=$row['extension'];
if(strpos($row['type'],"image")!==false){
$files['files'][$key]['versions']['thumb']['name']=$row['name'];
$files['files'][$key]['versions']['thumb']['url']=$row['url'];
$files['files'][$key]['width']=$row['width'];
$files['files'][$key]['height']=$row['height'];
}
}
$files['total']=$key+1;
print_r(json_encode($files));
}
?>
